attribute vec3 	normal; 
varying vec2 	texcoord;
uniform vec4	LTM0,
		LTM1,
		LTM2,
		LTM3,
		LTM4,
		LTM5;
uniform vec3	lightOfs,
		LD;
varying float	vertexLum;
uniform float	scale;	

#ifdef LIGHTCUBE
	varying vec3	dist,
			cubeProj;
#else
	varying vec2	Zproj;
	varying vec4	XYproj;	
#endif	

void main()
{
	gl_Position = ftransform();
	texcoord = gl_MultiTexCoord0.st;	

#ifdef LIGHTCUBE

	// distance
	dist.x = dot(gl_Vertex,LTM0);
	dist.y = dot(gl_Vertex,LTM1);
	dist.z = dot(gl_Vertex,LTM2);

	// light cube projection
	cubeProj.x = dot(gl_Vertex,LTM3);
	cubeProj.y = dot(gl_Vertex,LTM4);
	cubeProj.z = dot(gl_Vertex,LTM5);

#else
	// light XY projection
	XYproj.x = dot(gl_Vertex,LTM0);
	XYproj.y = dot(gl_Vertex,LTM1);
	XYproj.w = dot(gl_Vertex,LTM2);

	// light Z projection
	Zproj.x = dot(gl_Vertex,LTM3);
	Zproj.y = 1.0;
#endif

	// compute vertex luminance
	vertexLum=scale;
}